// const LOG = window.LOG || {
//   info: function(text) {
//     return console.log(text)
//   }
// }
//
// const jI18n = window.jI18n || {
//   translate: function(text) {
//     return text || '';
//   }
// }

const scheme = {
  currentSchemeData : null,

  renderMainSVG: function (width, height, innerItems) {
    if (!innerItems || !innerItems.length) innerItems = [];

    var svgCanvas = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
    svgCanvas.setAttribute('id', 'svgCanvas');
    svgCanvas.setAttribute('class', 'svg-main');
    svgCanvas.setAttribute('height', height + 50);

    var rect = document.createElementNS('http://www.w3.org/2000/svg', 'rect');

    rect.setAttribute('width', width);
    rect.setAttribute('height', height);
    rect.setAttribute('x', 75);
    rect.setAttribute('y', 25);
    rect.setAttribute('fill', '#fff');
    rect.setAttribute('stroke', '#000');
    rect.setAttribute('stroke', '#000');
    rect.setAttribute('stroke-width', 3);

    svgCanvas.appendChild(rect);

    for (var iInnerItem = 0; innerItems.length > iInnerItem; iInnerItem++) {
      svgCanvas.appendChild(innerItems[iInnerItem]);
    }

    return svgCanvas;
  },
  renderLine: function (xStartCoords, yCoords) {
    var line = document.createElementNS('http://www.w3.org/2000/svg', 'line');

    line.setAttribute('x1', xStartCoords);
    line.setAttribute('x2', xStartCoords + 75);
    line.setAttribute('y1', yCoords);
    line.setAttribute('y2', yCoords);
    line.setAttribute('stroke', '#000');
    line.setAttribute('stroke-width', 3);
    line.setAttribute('stroke-linecap', 'round');
    return line;
  },
  renderText: function (xCoords, yCoords, text, start) {
    var textObj = document.createElementNS('http://www.w3.org/2000/svg', 'text');

    textObj.setAttribute('width', 150);
    textObj.setAttribute('height', 40);
    textObj.setAttribute('translateable', '');
    textObj.setAttribute('x', xCoords);
    textObj.setAttribute('y', yCoords);
    textObj.setAttribute('fill', '#000');
    textObj.setAttribute('font-size', 14);
    textObj.setAttribute('font-weight', 900);
    textObj.setAttribute('text-anchor', start ? 'start' : 'end');

    textObj.innerHTML = jI18n.translate(text || '');
    return textObj;
  },
  renderWrapper: function (htmlObjectsArray) {
    var wrapper = document.createElement('div');
    wrapper.className = 'wrapper';
    for (var i = 0; htmlObjectsArray.length > i; i++) {
      wrapper.appendChild(htmlObjectsArray[i]);
    }
    return wrapper;
  },
  renderSignalData: function (i) {
    var signalDataSpan = document.createElement('span');
    signalDataSpan.id = 'selected_rangir_info' + i;
    signalDataSpan.className = 'signal-data';
    return signalDataSpan;
  },
  renderSignalOut: function (i) {
    var sigOut = document.createElement('span');
    sigOut.id = 'id_sig_out' + i;
    sigOut.className = 'sig_out';
    return sigOut;
  },
  renderBtn: function ({yCoordsPx, xCoordsPx, type, action, param, text}) {

    var arrowSVG = '<svg width="30" height="30" viewBox="0 0 16 16"><path stroke="black" stroke-width=".5" fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"/></svg>';

    var newButton = document.createElement('button');
    newButton.className = type === 'arrow' ? 'arrow-btn error' : 'square-btn error square-btn' + param;

    newButton.style.left = xCoordsPx;
    newButton.style.top = yCoordsPx;

    if (type === 'text') {
      newButton.innerHTML = text;
      newButton.style.border = 'none';
    } else {
      newButton.innerHTML = arrowSVG;
    }

    if(type === 'arrow') {
      newButton.appendChild(this.renderSignalOut(param));
    }

    if(type === 'square') {
      newButton.appendChild(this.renderSignalData(param));
    }

    newButton.onclick = function () {
      action(param)
    }

    return newButton;
  },
  renderScheme: function (schemeData, i) {
    var minLineStep = 45;
    var htmlObjectsArr = [];
    // htmlObjectsArr.push(this.renderSignalData(i));

    var lines = [];
    var texts = [];
    var btns = [];

    for (var iLeftCol = 0; schemeData.leftCol.length > iLeftCol; iLeftCol++) {
      var leftLineStep = (iLeftCol + 1) * minLineStep;
      var leftColItems = schemeData.leftCol[iLeftCol];

      lines.push(this.renderLine(0, leftLineStep + 25));
      texts.push(this.renderText(80, leftLineStep + 30, leftColItems[0], true));
      btns.push(this.renderBtn({
        yCoordsPx: leftLineStep + 5,
        xCoordsPx: 163,
        type: leftColItems[3] ? 'text' : 'square',
        action: leftColItems[1],
        param: leftColItems[2] || 0,
        text: leftColItems[3] || null,
      }));
    }

    for (var iRightCol = 0; schemeData.rightCol.length > iRightCol; iRightCol++) {
      var rightLineStep = (iRightCol + 1) * minLineStep;
      var rightColItems = schemeData.rightCol[iRightCol];

      lines.push(this.renderLine(225, rightLineStep));
      texts.push(this.renderText(220, rightLineStep + 5, rightColItems[0], false));
      btns.push(this.renderBtn({
        yCoordsPx: rightLineStep - 22,
        xCoordsPx: 471,
        type: rightColItems[3] ? 'text' : 'arrow',
        action: rightColItems[1],
        param: rightColItems[2] || 0,
        text: rightColItems[3] || null,
      }));
    }

    var rectHeight = schemeData.leftCol.length > schemeData.rightCol.length ? schemeData.leftCol.length * minLineStep + 40 : schemeData.rightCol.length * minLineStep + 40;
    htmlObjectsArr.push(this.renderMainSVG(150, rectHeight, lines.concat(texts)))
    htmlObjectsArr = htmlObjectsArr.concat(btns);

    document.body.appendChild(this.renderWrapper(htmlObjectsArr));
  },
  create: function (schemeData, i) {
    const _self = this;
    this.currentSchemeData = schemeData;
    window.addEventListener('load', function () {
      _self.renderScheme(schemeData, i)
    })
  },
  // Right col
  handleSigOut: function (arr, i) {
    var signalsContainer = document.getElementById('id_sig_out' + i);
    var signalsBtn = signalsContainer.parentNode;

    if (arr.length === 0) {
      signalsBtn.classList.add('error');
    } else {
      signalsBtn.classList.remove('error');
    }

    signalsContainer.innerHTML = arr.length === 0 ? '' : arr.map(function (s) {
      return '<span>' + s + '</span>'
    });
  },
  // Left col
  handleRangirInfo: function (arr, i) {
    var rangirContainer = document.getElementById('selected_rangir_info' + i);
    var rangirBtn = rangirContainer.parentNode;

    if (arr.length === 0) {
      rangirBtn.classList.add('error');
    } else {
      rangirBtn.classList.remove('error');
    }

    rangirContainer.innerHTML = arr.length === 0 ? '' : arr.map(function (s) {
      return '<span>' + s + '</span>'
    });

  },
  setRangirHint: function (i,arr) {
    const leftCol = this.currentSchemeData.leftCol.find(el => el[2] === i);
    LOG.info("setRangirHint called");
    if(leftCol) {
      this.handleRangirInfo(arr, i);
    } else {
      this.handleSigOut(arr, i);
    }
  },
  showDialog: function (i) {
    try {
      jDialog.displayDialog(i);
    } catch (e) {
      document.getElementById('msg').innerHTML = JSON.stringify(e);
    }
  }
}
